use master
GO

set nocount on 

--set to 0 to skip updating the A4Survey_Client_Template database, or to 1 to update the template database
declare @ProcessTemplateDB bit = 1  

declare @ClientPayload01 nvarchar(max) = N'
-- 66448
-- Rename SAMLMetadataUrl to SAMLEntityId
IF DB_NAME() <> ''Acuity4_Public_Content''
BEGIN
    IF EXISTS (SELECT TOP 1 1 FROM [DBO].[CLIENTSETTING] WHERE [KEY] = ''SAMLMetadataUrl'')
    BEGIN
        -- Rename the key
        UPDATE [DBO].[CLIENTSETTING] SET [KEY] = ''SAMLEntityId''
        WHERE [KEY] = ''SAMLMetadataUrl''
    END
END
'

declare @ClientPayload02 nvarchar(max) = N'
-- 66454
-- Rename SAMLX509SigningCertificate to SAMLValidationCertificate
-- Insert Default values for previously created Clients
IF DB_NAME() <> ''Acuity4_Public_Content''
BEGIN
    IF EXISTS (SELECT TOP 1 1 FROM [DBO].[CLIENTSETTING] WHERE [KEY] = ''SAMLX509SigningCertificate'')
    BEGIN
        -- Rename the key
        UPDATE [DBO].[CLIENTSETTING] SET [KEY] = ''SAMLValidationCertificate'' WHERE [KEY] = ''SAMLX509SigningCertificate''
    END

    -- If SAML Enabled already (for previously configured client for SAML)
    IF EXISTS (SELECT TOP 1 1 FROM [DBO].[CLIENTSETTING] WHERE [KEY] = ''IsSaml'' and [VALUE] = ''True'')
    BEGIN
        -- If AllowUnsolicitedAuthnResponse is not exist in ClientSetting
        -- To be compatible with old hard-coded value for AllowUnsolicitedAuthnResponse as true
        -- Insert a ClientSetting as SAMLAllowUnsolicitedAuthnResponse = ''True''
        IF NOT EXISTS (SELECT TOP 1 1 FROM [DBO].[CLIENTSETTING] WHERE [KEY] = ''SAMLAllowUnsolicitedAuthnResponse'')
        BEGIN
            INSERT INTO [DBO].[CLIENTSETTING] ([KEY], [VALUE]) VALUES (''SAMLAllowUnsolicitedAuthnResponse'', ''True'')
        END

    END
END
'

declare @ClientPayload03 nvarchar(max) = N'
-- 66456
-- Fixing 1 issue caused by DEV-80927 and DEV-80928
-- Context and Abbreviations: SAML Settings, SP => Service Provider, IdP => Identity Provider
-- With previous changes SAMLMetadataUrl renamed to SAMLEntityId(ref: ClientModelUpdate_6600_66448.sql) and mapped to SpEntityId by a mistake, 
-- It should have renamed to SAMLSpEntityId and mapped to SpEntityId(ref: ConfigFacade)
-- With second change once ClientSettings opened and saved(even without editing any existing values) 
-- We''ve inserted SAMLIdpEntityId key along with other SAML settings with their default values and its currently mapped IdPEntityId.
-- To be able to correct this wrong mapping, we''ll:
-- 1. Rename SAMLIdpEntityId to SAMLSpEntityId
-- 2. Rename SAMLEntityId to SAMLIdpEntityId
-- Expected end result
-- 1. SAMLIdpEntityId(renamed from SAMLEntityId, currently holds Idp Entity ID) mapped to IdPEntityId in ConfigFacade
-- 2. SAMLSpEntityId(renamed from SAMLIdpEntityId, currently holds Sp Entity ID) mapped to SpEntityId in ConfigFacade
IF DB_NAME() <> ''Acuity4_Public_Content''
BEGIN
    -- If SAMLSpEntityId already exists, means that this client has already updated with proper renaming.
    IF NOT EXISTS (SELECT TOP 1 1 FROM [DBO].[CLIENTSETTING] WHERE [KEY] = ''SAMLSpEntityId'')
    BEGIN
        SET NOCOUNT ON
        DECLARE @entityIdExists INT = (SELECT COUNT([Id]) FROM [DBO].[CLIENTSETTING] WHERE [KEY] = ''SAMLEntityId'');
        DECLARE @idpEntityIdExists INT = (SELECT COUNT([Id]) FROM [DBO].[CLIENTSETTING] WHERE [KEY] = ''SAMLIdpEntityId'');
        IF (@entityIdExists = 1 AND @idpEntityIdExists = 1)
        BEGIN
            -- Means this client affected by both change-set 187320 and 186917
            -- First rename SAMLIdpEntityId to let renaming SAMLEntityId to SAMLIdpEntityId on second step
            UPDATE [DBO].[CLIENTSETTING] SET [KEY] = ''SAMLSpEntityId'' WHERE [KEY] = ''SAMLIdpEntityId''
            UPDATE [DBO].[CLIENTSETTING] SET [KEY] = ''SAMLIdpEntityId'' WHERE [KEY] = ''SAMLEntityId''
        END

        IF (@entityIdExists = 1 AND @idpEntityIdExists = 0)
        BEGIN
            -- Means this client affected only by 186917 and not yet affected by 187320, because its not edited yet after 187320 deployed.
            -- Directly rename SAMLEntityId to SAMLIdpEntityId, because currently it holds value of Idp Entity ID(Previously configured in that what).
            -- As SAMLSpEntityId will be inserted at first edit, we won''t insert it in this SQL.
            UPDATE [DBO].[CLIENTSETTING] SET [KEY] = ''SAMLIdpEntityId'' WHERE [KEY] = ''SAMLEntityId''
        END
    END
END
'

--declare @SurveyPayload01 nvarchar(max) = N'waitfor delay ''0:00:01'''

create table #DB (
	DBName nvarchar(128),
	Processed tinyint default 0
)
create table #Survey (
	DBName nvarchar(128),
	SchemaName nvarchar(128),
	Processed tinyint default 0
)
create table #SurveyVerif (
	DBName nvarchar(128),
	SchemaName nvarchar(128)
)
create table #SurveysDone (
	DBName nvarchar(128) collate database_default,
	SchemaName nvarchar(128) collate database_default
)
declare @AllDone bit = 0, 
        @TotalClients int, 
		@TotalSurveys int, 
		@ClientCounter int, 
		@SurveyCounter int, 
		@ThisClient nvarchar(128), 
		@ThisSurvey nvarchar(128), 
		@ClientCursor cursor, 
		@SurveyCursor cursor, 
		@DBSQL nvarchar(200), 
		@SQL nvarchar(max), 
		@StatusMessage varchar(max), 
		@StatusPercent tinyint

while @AllDone = 0 begin
	select @TotalClients = 0, @TotalSurveys = 0, @ClientCounter = 0, @SurveyCounter = 0
	insert into #DB 
	select 'A4Survey_Client_' + cast(Id as nvarchar(16)), 0 from Acuity4.dbo.Client
	     
    if @ProcessTemplateDB = 1 
	   insert into #DB values (N'A4Survey_Client_Template', 0)

	select @TotalClients = count(*) 
	       from #DB
	
	set @ClientCursor = cursor scroll dynamic for select DBName from #DB for update of Processed
	open @ClientCursor
	fetch next from @ClientCursor into @ThisClient
	while @@FETCH_STATUS = 0 begin
		select @ClientCounter += 1
		select @DBSQL = @ThisClient + N'.sys.sp_executesql'
		select @SQL = N'insert into #Survey select ''' + @ThisClient + ''', SchemaName, 0 from ' + @ThisClient + '.dbo.Survey except select DBName, SchemaName, 0 from #SurveysDone'
		exec @DBSQL @SQL
		select @StatusMessage = 'Updating client database "%s" (%u of %u, %u%%)', @StatusPercent = 100.0 * @ClientCounter / @TotalClients
		raiserror (@StatusMessage, 0, 1, @ThisClient, @ClientCounter, @TotalClients, @StatusPercent) with nowait
		
		print 'Client Payload 1'
		select @SQL = replace(replace(@ClientPayload01, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'Client Payload 2'
		select @SQL = replace(replace(@ClientPayload02, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'Client Payload 3'
		select @SQL = replace(replace(@ClientPayload03, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'All Client Payload done for  client ' + @ThisClient + '!'

		update #DB set Processed = 1 where current of @ClientCursor
		fetch next from @ClientCursor into @ThisClient
	end


	close @ClientCursor
	deallocate @ClientCursor

-- Backup client template db if it was updated
	IF @ProcessTemplateDB = 1 
    BEGIN
      PRINT 'Creating backup for A4Survey_Client_Template';
      SET @SQL = 'USE Acuity4;
                  exec [dbo].[VX_sp_BackupClientTemplateDatabase]'
      EXEC (@SQL); 
    END

    SELECT @AllDone = 1
end



--select * from #DB
--select * from #Survey

drop table #DB
drop table #Survey
drop table #SurveyVerif
drop table #SurveysDone